#!/usr/bin/env ruby
require 'fileutils'

def copy_files()
  (0..8).each do | x_value |
    (0..15).each do | y_value |
      new_file_name = "#{x_value.to_s.rjust(2, '0')}-#{y_value.to_s.rjust(2, '0')}.tmx"
      old_file_name = "00-00.tmx"

      
      FileUtils.cp(old_file_name, new_file_name) unless (new_file_name == old_file_name)
    end
  end
end

def generate_json(x_value, y_value)
  # x_value = 5
  # y_value = 1
  output = "  {
    \"fileName\": \"#{"%02d" % y_value}-#{"%02d" % x_value}.tmx\",
    \"height\": 352,
    \"width\": 512,
    \"x\": #{x_value * 512},
    \"y\": #{y_value * 352}
  },
"

  output
end

def world_map_json()
  full_output = ""
  (0..8).each do | y |
    (0..15).each do | x |
      full_output += generate_json(x, y)
    end
  end

  puts full_output
end

world_map_json()